#11/19/24 -created


import pygame
import random
import time

pygame.init()
ds = pygame.display.set_mode((800,600))

star_x_list = []
star_y_list = []
bullets = []
asteroids = []
craters = []
population = 8000000000
ammo = 5

#moons
moon1 = pygame.image.load("moon1.png")
moon2 = pygame.image.load("moon2.png")
moon3 = pygame.image.load("moon3.png")
moon4 = pygame.image.load("moon4.png")
moon5 = pygame.image.load("moon5.png")
moon6 = pygame.image.load("moon6.png")
moon_images = [moon1,moon2,moon3,moon4,moon5,moon6]



#clock/score
fpsClock = pygame.time.Clock()
start_time = pygame.time.get_ticks()
score = 0

#colors
yellow = (255,232,140)
white = (255,255,255)
red = (255,100,100)
grey = (200,200,200)
black = (0,0,0)
green = (0,200,0)

#mixer
pygame.mixer.set_num_channels(8)
pygame.mixer.music.load("Axel_F_Dreamscaper_remix.mp3")
pygame.mixer.music.set_volume(0.25)
pygame.mixer.music.play(loops=-1,start=0.0)

bwomp = pygame.mixer.Sound("bwomp.mp3")
bwomp.set_volume(0.25)
laser = pygame.mixer.Sound("laser_gun.mp3")
laser.set_volume(0.25)
explosion = pygame.mixer.Sound("roblox_explosion.mp3")
explosion.set_volume(0.25)

def super_earth():
    pygame.draw.ellipse(ds,green,(0,540,800,150))

#craters
class Crater:
    def __init__(self,x,y):
        self.x = x
        self.y = y

    def render(self):
        pygame.draw.circle(ds,black,(self.x,self.y),35) 
    
#bullets
class Bullet:
    def __init__(self,x,y):
        self.x = x
        self.y = y
        self.speed = 10

    def move(self):
        self.y-=self.speed

    def render(self):
        pygame.draw.circle(ds,yellow,(self.x,self.y),3)
   
    
#asteroids
class Asteroid:
    def __init__(self):
        self.x = random.randint(0,799)
        self.y = -50
        self.speed = random.randint(2,4)
        self.size = 90
        self.moon = pygame.transform.scale(random.choice(moon_images),(self.size,self.size))
        
    def move(self):
        self.y += self.speed

    def render(self):
        ds.blit(self.moon,(self.x-40,self.y))

        
#stars
for i in range(1000):
    star_x_list.append(random.randint(0,799))
    star_y_list.append(random.randint(0,599))

def drawStar(x,y):
    pygame.draw.circle(ds,(100,150,255),(x,y),random.randint(2,3))

#spaceship
class Spaceship:
    def __init__(self):
        self.x = 400
        self.y = 550
        self.speed = 6

    def move_left(self):
        if self.x-self.speed>0:
            self.x-=self.speed

    def move_right(self):
        if self.x+self.speed<800:
            self.x+=self.speed

    def render(self):
        pygame.draw.polygon(ds,yellow,((self.x,self.y-20),(self.x-15,self.y+10),(self.x+15,self.y+10)))


spaceship = Spaceship()
game_start = True

while game_start == True:
    fpsClock.tick(120)
    pygame.event.pump()
    keys = pygame.key.get_pressed()
    
    if keys[pygame.K_ESCAPE]:
        break

    for i in range(len(star_x_list)):
        drawStar(star_x_list[i],star_y_list[i])
        
    if keys[pygame.K_a]:
        spaceship.move_left()
        
    if keys[pygame.K_d]:
        spaceship.move_right()
        
    if keys[pygame.K_SPACE] and ammo >0:
        bullets.append(Bullet(spaceship.x, spaceship.y - 20))
        ammo -= 1
        laser.play()
        
    # 1% chance of spawning asteroids... i think
    if random.randint(1,100)<=1:
        asteroids.append(Asteroid())

    #rendering
    ds.fill(black)
        
    for i in range(len(star_x_list)):
        drawStar(star_x_list[i],star_y_list[i])
        
    super_earth()
    for crater in craters:
        crater.render()   
    spaceship.render()
    
    for bullet in bullets[:]:
        bullet.move()
        bullet.render()
        if bullet.y<0:
            bullets.remove(bullet)
            ammo += 1
            
    for asteroid in asteroids[:]:
        asteroid.move()
        asteroid.render()
        if asteroid.y > 500:
            asteroids.remove(asteroid)
            craters.append(Crater(asteroid.x,540))
            population_loss = random.randint(60000000, 100000000)
            population -= population_loss
            explosion.play()
            if population <= 0:
                game_start = False
                break
                
    #collisions
    for asteroid in asteroids[:]:
        for bullet in bullets[:]:
            distance = ((asteroid.x-bullet.x)**2 + (asteroid.y-bullet.y)**2)**0.5
            if distance < 35:
                bullets.remove(bullet)
                asteroids.remove(asteroid)
                ammo += 1
                bwomp.play()
                break
            
    #stats
    now_time = (pygame.time.get_ticks()-start_time) // 1000
    myfont = pygame.font.SysFont("Comic Sans",36,bold=False,italic=False)
    bullets_text = myfont.render("Bullets: "+str(len(bullets)), True, white)
    asteroids_text = myfont.render("Asteroids: "+str(len(asteroids)), True, white)
    population_text = myfont.render("Population: "+str(population), True, white)
    time_text = myfont.render("Time: "+str(now_time)+" sec", True, white)

    ds.blit(bullets_text, (10,0))
    ds.blit(asteroids_text, (570,0))
    ds.blit(population_text, (350,550))
    ds.blit(time_text, (10,550))

            
    pygame.display.update()
    
explosion.play()    
ds.fill(black)
myfont = pygame.font.SysFont("Comic Sans",60,bold=False,italic=False)
game_over_text = myfont.render("Game Over", True, red)
time_survived_text = myfont.render("Time Survived: "+str(now_time)+" seconds", True, red)
ds.blit(game_over_text, (240,150))
ds.blit(time_survived_text, (15,320))
pygame.display.update()
pygame.time.wait(5000)

pygame.mixer.music.stop()
pygame.quit()


